/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitLocker;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitMutatorImpl;
import com.cburch.logisim.circuit.CircuitTransactionResult;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.WireRepair;
import com.cburch.logisim.circuit.appear.CircuitPins;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public abstract class CircuitTransaction {
    public static final Integer READ_ONLY = 1;
    public static final Integer READ_WRITE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CircuitTransactionResult execute() {
        CircuitTransactionResult result;
        CircuitMutatorImpl mutator = new CircuitMutatorImpl();
        Map<Circuit, Lock> locks = CircuitLocker.acquireLocks(this, mutator);
        try {
            CircuitMutatorImpl circMutator;
            try {
                this.run(mutator);
            }
            catch (CircuitLocker.LockException e) {
                System.out.println("*** Circuit Lock Bug Diagnostics ***");
                System.out.println("This thread: " + String.valueOf(Thread.currentThread()));
                System.out.println("owns " + locks.size() + " locks, as follows:");
                for (Map.Entry<Circuit, Lock> entry : locks.entrySet()) {
                    Circuit circuit = entry.getKey();
                    Lock lock = entry.getValue();
                    System.out.printf("  circuit \"%s\" [lock serial: %d] with lock %s\n", circuit.getName(), circuit.getLocker().getSerialNumber(), lock);
                }
                System.out.println("attempted to access without a lock:");
                System.out.printf("  circuit \"%s\" [lock serial: %d/%d]\n", e.getCircuit().getName(), e.getSerialNumber(), e.getCircuit().getLocker().getSerialNumber());
                System.out.println("  owned by thread: " + String.valueOf(e.getMutatingThread()));
                System.out.println("  with mutator: " + String.valueOf(e.getCircuitMutator()));
                throw e;
            }
            Collection<Circuit> modified = mutator.getModifiedCircuits();
            for (Circuit circuit : modified) {
                ReplacementMap repl;
                circMutator = circuit.getLocker().getMutator();
                if (circMutator != mutator || (repl = mutator.getReplacementMap(circuit)) == null) continue;
                CircuitPins pins = circuit.getAppearance().getCircuitPins();
                pins.transactionCompleted(repl);
            }
            for (Circuit circuit : modified) {
                circMutator = circuit.getLocker().getMutator();
                if (circMutator == mutator) {
                    WireRepair repair = new WireRepair(circuit);
                    repair.run(mutator);
                    continue;
                }
                circMutator.markModified(circuit);
            }
            result = new CircuitTransactionResult(mutator);
            for (Circuit circuit : result.getModifiedCircuits()) {
                circuit.fireEvent(6, result);
            }
        }
        finally {
            CircuitLocker.releaseLocks(locks);
        }
        return result;
    }

    protected abstract Map<Circuit, Integer> getAccessedCircuits();

    protected abstract void run(CircuitMutator var1);
}

