/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.WireFactory;
import com.cburch.logisim.circuit.WireIterator;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.tools.CustomHandles;
import com.cburch.logisim.util.Cache;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Stroke;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class Wire
implements com.cburch.logisim.comp.Component,
AttributeSet,
CustomHandles,
Iterable<Location> {
    public static final int WIDTH = 3;
    public static final int WIDTH_BUS = 4;
    public static final int HIGHLIGHTED_WIDTH = 4;
    public static final int HIGHLIGHTED_WIDTH_BUS = 5;
    public static final Stroke HIGHLIGHTED_STROKE = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{7.0f}, 0.0f);
    public static final double DOT_MULTIPLY_FACTOR = 1.35;
    public static final AttributeOption VALUE_HORZ = new AttributeOption("horz", Strings.S.getter("wireDirectionHorzOption"));
    public static final AttributeOption VALUE_VERT = new AttributeOption("vert", Strings.S.getter("wireDirectionVertOption"));
    public static final Attribute<AttributeOption> DIR_ATTR = Attributes.forOption("direction", Strings.S.getter("wireDirectionAttr"), new AttributeOption[]{VALUE_HORZ, VALUE_VERT});
    public static final Attribute<Integer> LEN_ATTR = Attributes.forInteger("length", Strings.S.getter("wireLengthAttr"));
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(DIR_ATTR, LEN_ATTR);
    private static final Cache cache = new Cache();
    final Location e0;
    final Location e1;
    final boolean isXEqual;
    private boolean isDrcHighlighted = false;
    private Color drcWireMarkColor = Netlist.DRC_WIRE_MARK_COLOR;

    public static Wire create(Location e0, Location e1) {
        return (Wire)cache.get(new Wire(e0, e1));
    }

    private Wire(Location e0, Location e1) {
        boolean bl = this.isXEqual = e0.getX() == e1.getX();
        if (this.isXEqual) {
            if (e0.getY() > e1.getY()) {
                this.e0 = e1;
                this.e1 = e0;
            } else {
                this.e0 = e0;
                this.e1 = e1;
            }
        } else if (e0.getX() > e1.getX()) {
            this.e0 = e1;
            this.e1 = e0;
        } else {
            this.e0 = e0;
            this.e1 = e1;
        }
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public boolean contains(Location q) {
        int qx = q.getX();
        int qy = q.getY();
        if (this.isXEqual) {
            int wx = this.e0.getX();
            return qx >= wx - 2 && qx <= wx + 2 && this.e0.getY() <= qy && qy <= this.e1.getY();
        }
        int wy = this.e0.getY();
        return qy >= wy - 2 && qy <= wy + 2 && this.e0.getX() <= qx && qx <= this.e1.getX();
    }

    @Override
    public boolean contains(Location pt, Graphics g) {
        return this.contains(pt);
    }

    @Override
    public boolean containsAttribute(Attribute<?> attr) {
        return ATTRIBUTES.contains(attr);
    }

    @Override
    public void draw(ComponentDrawContext context) {
        CircuitState state = context.getCircuitState();
        Graphics g = context.getGraphics();
        GraphicsUtil.switchToWidth(g, 3);
        g.setColor(state.getValue(this.e0).getColor());
        g.drawLine(this.e0.getX(), this.e0.getY(), this.e1.getX(), this.e1.getY());
    }

    @Override
    public void drawHandles(ComponentDrawContext context) {
        context.drawHandle(this.e0);
        context.drawHandle(this.e1);
    }

    @Override
    public boolean endsAt(Location pt) {
        return this.e0.equals(pt) || this.e1.equals(pt);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Wire)) {
            return false;
        }
        Wire w = (Wire)other;
        return w.e0.equals(this.e0) && w.e1.equals(this.e1);
    }

    @Override
    public void expose(ComponentDrawContext context) {
        Component dest = context.getDestination();
        int x0 = this.e0.getX();
        int y0 = this.e0.getY();
        dest.repaint(x0 - 5, y0 - 5, this.e1.getX() - x0 + 10, this.e1.getY() - y0 + 10);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        for (Attribute<?> attr : ATTRIBUTES) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this;
    }

    @Override
    public Bounds getBounds() {
        int x0 = this.e0.getX();
        int y0 = this.e0.getY();
        return Bounds.create(x0 - 2, y0 - 2, this.e1.getX() - x0 + 5, this.e1.getY() - y0 + 5);
    }

    @Override
    public Bounds getBounds(Graphics g) {
        return this.getBounds();
    }

    @Override
    public EndData getEnd(int index) {
        return new EndData(this.getEndLocation(index), BitWidth.UNKNOWN, 3);
    }

    public Location getEnd0() {
        return this.e0;
    }

    public Location getEnd1() {
        return this.e1;
    }

    public Location getEndLocation(int index) {
        return index == 0 ? this.e0 : this.e1;
    }

    @Override
    public List<EndData> getEnds() {
        return new EndList();
    }

    @Override
    public ComponentFactory getFactory() {
        return WireFactory.instance;
    }

    @Override
    public Object getFeature(Object key) {
        if (key == CustomHandles.class) {
            return this;
        }
        return null;
    }

    public int getLength() {
        return this.e1.getY() - this.e0.getY() + (this.e1.getX() - this.e0.getX());
    }

    @Override
    public Location getLocation() {
        return this.e0;
    }

    public Location getOtherEnd(Location loc) {
        return loc.equals(this.e0) ? this.e1 : this.e0;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == DIR_ATTR) {
            return (V)(this.isXEqual ? VALUE_VERT : VALUE_HORZ);
        }
        if (attr == LEN_ATTR) {
            return (V)Integer.valueOf(this.getLength());
        }
        return null;
    }

    public int hashCode() {
        return this.e0.hashCode() * 31 + this.e1.hashCode();
    }

    public boolean isParallel(Wire other) {
        return this.isXEqual == other.isXEqual;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return true;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return false;
    }

    public boolean isVertical() {
        return this.isXEqual;
    }

    @Override
    public Iterator<Location> iterator() {
        return new WireIterator(this.e0, this.e1);
    }

    private boolean overlaps(Location q0, Location q1, boolean includeEnds) {
        if (this.isXEqual) {
            int x0 = q0.getX();
            if (x0 != q1.getX() || x0 != this.e0.getX()) {
                return false;
            }
            if (includeEnds) {
                return this.e1.getY() >= q0.getY() && this.e0.getY() <= q1.getY();
            }
            return this.e1.getY() > q0.getY() && this.e0.getY() < q1.getY();
        }
        int y0 = q0.getY();
        if (y0 != q1.getY() || y0 != this.e0.getY()) {
            return false;
        }
        if (includeEnds) {
            return this.e1.getX() >= q0.getX() && this.e0.getX() <= q1.getX();
        }
        return this.e1.getX() > q0.getX() && this.e0.getX() < q1.getX();
    }

    public boolean overlaps(Wire other, boolean includeEnds) {
        return this.overlaps(other.e0, other.e1, includeEnds);
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        throw new IllegalArgumentException("read only attribute");
    }

    public boolean sharesEnd(Wire other) {
        return this.e0.equals(other.e0) || this.e1.equals(other.e0) || this.e0.equals(other.e1) || this.e1.equals(other.e1);
    }

    public String toString() {
        return "Wire[" + String.valueOf(this.e0) + "-" + String.valueOf(this.e1) + "]";
    }

    public void setDrcHighlight(boolean highlight) {
        this.isDrcHighlighted = highlight;
    }

    public boolean isDrcHighlighted() {
        return this.isDrcHighlighted;
    }

    public void setDrcHighlightColor(Color col) {
        this.drcWireMarkColor = col;
    }

    public Color getDrcHighlightColor() {
        return this.drcWireMarkColor;
    }

    private class EndList
    extends AbstractList<EndData> {
        private EndList() {
        }

        @Override
        public EndData get(int i) {
            return Wire.this.getEnd(i);
        }

        @Override
        public int size() {
            return 2;
        }
    }
}

