/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.data.AttributeOptionInterface;
import com.cburch.logisim.data.Strings;
import com.cburch.logisim.util.StringGetter;

public class Direction
implements AttributeOptionInterface {
    public static final Direction EAST = new Direction("east", Strings.S.getter("directionEastOption"), Strings.S.getter("directionEastVertical"), 0);
    public static final Direction NORTH = new Direction("north", Strings.S.getter("directionNorthOption"), Strings.S.getter("directionNorthVertical"), 1);
    public static final Direction WEST = new Direction("west", Strings.S.getter("directionWestOption"), Strings.S.getter("directionWestVertical"), 2);
    public static final Direction SOUTH = new Direction("south", Strings.S.getter("directionSouthOption"), Strings.S.getter("directionSouthVertical"), 3);
    public static final Direction[] cardinals = new Direction[]{EAST, NORTH, WEST, SOUTH};
    private final String name;
    private final StringGetter disp;
    private final StringGetter vert;
    private final int id;

    public static Direction parse(String str) {
        if (str.equals(Direction.EAST.name)) {
            return EAST;
        }
        if (str.equals(Direction.WEST.name)) {
            return WEST;
        }
        if (str.equals(Direction.NORTH.name)) {
            return NORTH;
        }
        if (str.equals(Direction.SOUTH.name)) {
            return SOUTH;
        }
        throw new NumberFormatException("illegal direction '" + str + "'");
    }

    private Direction(String name, StringGetter disp, StringGetter vert, int id) {
        this.name = name;
        this.disp = disp;
        this.vert = vert;
        this.id = id;
    }

    public boolean equals(Direction other) {
        return this.id == other.id;
    }

    public StringGetter getDisplayGetter() {
        return this.disp;
    }

    public Direction getLeft() {
        return cardinals[(this.id + 1) % 4];
    }

    public Direction getRight() {
        return cardinals[(this.id + 3) % 4];
    }

    @Override
    public Object getValue() {
        return this;
    }

    public int hashCode() {
        return this.id;
    }

    public Direction reverse() {
        return cardinals[(this.id + 2) % 4];
    }

    public int toDegrees() {
        return this.id * 90;
    }

    @Override
    public String toDisplayString() {
        return this.disp.toString();
    }

    public double toRadians() {
        return (double)this.id * Math.PI / 2.0;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String toVerticalDisplayString() {
        return this.vert.toString();
    }
}

