/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LibraryManager;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Projects;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class ProjectsDirty {
    private static final ProjectListListener projectListListener = new ProjectListListener();
    private static final List<DirtyListener> listeners = new ArrayList<DirtyListener>();

    private ProjectsDirty() {
    }

    public static void initialize() {
        Projects.addPropertyChangeListener("projectList", projectListListener);
    }

    private static class ProjectListListener
    implements PropertyChangeListener {
        private ProjectListListener() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent event) {
            for (DirtyListener listener : listeners) {
                listener.proj.removeLibraryListener(listener);
            }
            listeners.clear();
            for (Project proj : Projects.getOpenProjects()) {
                DirtyListener l = new DirtyListener(proj);
                proj.addLibraryListener(l);
                listeners.add(l);
                LogisimFile lib = proj.getLogisimFile();
                LibraryManager.instance.setDirty(lib.getLoader().getMainFile(), lib.isDirty());
            }
        }
    }

    private static class DirtyListener
    implements LibraryListener {
        final Project proj;

        DirtyListener(Project proj) {
            this.proj = proj;
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            if (event.getAction() == 7) {
                LogisimFile lib = this.proj.getLogisimFile();
                File file = lib.getLoader().getMainFile();
                LibraryManager.instance.setDirty(file, lib.isDirty());
            }
        }
    }
}

