/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.Strings;
import java.util.LinkedList;
import java.util.List;

public class SevenSegmentScanningDriving {
    public static final String SEVEN_SEG_SCANNING_MODE = "SevenSegScanningMode";
    public static final char SEVEN_SEG_DECODED = '\u0000';
    public static final char SEVEN_SEG_SCANNING_ACTIVE_LOW = '\u0001';
    public static final char SEVEN_SEG_SCANNING_ACTIVE_HI = '\u0002';
    public static final char UNKNOWN = '\u00ff';
    public static final String[] DRIVING_STRINGS = new String[]{"SevenSegDecoded", "SevenSegScanningActiveLow", "SevenSegScanningActiveHi"};

    public static String getConstrainedDriveMode(char id) {
        return id >= '\u0000' && id <= '\u0002' ? DRIVING_STRINGS[id] : "Unknown";
    }

    public static char getId(String identifier) {
        char result = '\u0000';
        List<String> thelist = SevenSegmentScanningDriving.getStrings();
        for (String s : thelist) {
            if (s.equals(identifier)) {
                return result;
            }
            result = (char)(result + '\u0001');
        }
        return '\u00ff';
    }

    public static List<String> getStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(DRIVING_STRINGS[0]);
        result.add(DRIVING_STRINGS[1]);
        result.add(DRIVING_STRINGS[2]);
        return result;
    }

    public static List<String> getDisplayStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(Strings.S.get(DRIVING_STRINGS[0]));
        result.add(Strings.S.get(DRIVING_STRINGS[1]));
        result.add(Strings.S.get(DRIVING_STRINGS[2]));
        return result;
    }
}

