/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class SimulationIcon
extends BaseIcon {
    public static final int SIM_PLAY = 0;
    public static final int SIM_PAUSE = 1;
    public static final int SIM_STEP = 2;
    public static final int SIM_ENABLE = 3;
    public static final int SIM_DISABLE = 4;
    public static final int SIM_HALF_TICK = 5;
    public static final int SIM_FULL_TICK = 6;
    private int currentType;

    public SimulationIcon(int type) {
        this.currentType = type;
    }

    public void setType(int type) {
        this.currentType = type;
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        int wh = this.getIconWidth() - this.scale(1);
        g2.setStroke(new BasicStroke(this.scale(1)));
        g2.setColor(this.currentType > 2 ? Color.LIGHT_GRAY : Color.WHITE);
        g2.fillOval(0, 0, wh, wh);
        if (this.currentType > 2) {
            g2.setColor(Color.WHITE);
            int wh1 = wh - this.scale(4);
            g2.fillOval(this.scale(2), this.scale(2), wh1, wh1);
            g2.setStroke(new BasicStroke(this.scale(2)));
            g2.setColor(Color.BLACK);
            g2.drawLine(this.getIconWidth() / 2, this.getIconWidth() / 2, 3 * wh / 4, wh / 4);
            g2.setColor(Color.RED);
            g2.drawLine(this.getIconWidth() / 2, this.getIconWidth() / 2, wh / 4, wh / 4);
            g2.setStroke(new BasicStroke(this.scale(1)));
        }
        g2.setColor(Color.DARK_GRAY);
        g2.drawOval(0, 0, wh, wh);
        switch (this.currentType) {
            case 2: {
                g2.setColor(Color.GREEN.brighter());
                g2.fillRect(this.scale(10), this.scale(3), this.scale(1), this.scale(10));
                g2.setColor(Color.GREEN.darker());
                g2.drawRect(this.scale(10), this.scale(3), this.scale(1), this.scale(10));
            }
            case 0: {
                int[] xpos = new int[]{this.scale(6), this.scale(10), this.scale(6)};
                int[] ypos = new int[]{this.scale(3), this.scale(8), this.scale(13)};
                g2.setColor(Color.GREEN.brighter());
                g2.fillPolygon(xpos, ypos, 3);
                g2.setColor(Color.GREEN.darker());
                g2.drawPolygon(xpos, ypos, 3);
                break;
            }
            case 1: {
                g2.setColor(Color.RED.brighter());
                g2.fillRect(this.scale(5), this.scale(3), this.scale(2), this.scale(10));
                g2.fillRect(this.scale(9), this.scale(3), this.scale(2), this.scale(10));
                g2.setColor(Color.RED.darker());
                g2.drawRect(this.scale(5), this.scale(3), this.scale(2), this.scale(10));
                g2.drawRect(this.scale(9), this.scale(3), this.scale(2), this.scale(10));
                break;
            }
            case 6: {
                g2.setStroke(new BasicStroke(this.scale(2)));
                g2.setColor(Color.MAGENTA.darker().darker());
                g2.drawArc(0, 0, wh, wh, -135, -180);
                int[] x1 = new int[]{this.scale(10), this.scale(14), this.scale(14)};
                int[] y1 = new int[]{wh / 4, wh / 4, wh / 4 - this.scale(4)};
                g2.fillPolygon(x1, y1, 3);
                g2.drawPolygon(x1, y1, 3);
            }
            case 5: {
                g2.setStroke(new BasicStroke(this.scale(2)));
                g2.setColor(Color.MAGENTA);
                g2.drawArc(0, 0, wh, wh, 45, -180);
                int[] x = new int[]{this.scale(3), this.scale(7), this.scale(3)};
                int[] y = new int[]{3 * wh / 4, 3 * wh / 4, 3 * wh / 4 + this.scale(4)};
                g2.fillPolygon(x, y, 3);
                g2.drawPolygon(x, y, 3);
                break;
            }
            case 3: {
                int[] x0 = new int[]{this.scale(6), this.scale(10), this.scale(6)};
                int[] y0 = new int[]{this.scale(8), this.scale(12), this.scale(15)};
                g2.setColor(Color.GREEN.darker());
                g2.fillPolygon(x0, y0, 3);
                g2.setColor(Color.GREEN.darker().darker().darker());
                g2.drawPolygon(x0, y0, 3);
                break;
            }
            case 4: {
                g2.setStroke(new BasicStroke(this.scale(3)));
                g2.setColor(Color.RED.darker().darker());
                g2.drawLine(this.scale(6), this.scale(9), this.scale(6), this.scale(14));
                g2.drawLine(this.scale(10), this.scale(9), this.scale(10), this.scale(14));
            }
        }
    }
}

