/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.test;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.FailException;
import com.cburch.logisim.data.TestException;
import com.cburch.logisim.data.TestVector;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.log.ValueTable;
import com.cburch.logisim.gui.test.Model;
import com.cburch.logisim.gui.test.ModelListener;
import com.cburch.logisim.gui.test.TestFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;

class TestPanel
extends JPanel
implements ValueTable.Model {
    static final Color failColor = new Color(0xFF9999);
    private static final long serialVersionUID = 1L;
    private final TestFrame testFrame;
    private final ValueTable table;
    private final MyListener myListener = new MyListener();

    public TestPanel(TestFrame frame) {
        this.testFrame = frame;
        this.table = new ValueTable(this.getModel() == null ? null : this);
        this.setLayout(new BorderLayout());
        this.add(this.table);
        this.modelChanged(null, this.getModel());
    }

    @Override
    public void changeColumnValueRadix(int i) {
        if (i == 0) {
            return;
        }
        TestVector vec = this.getModel().getVector();
        switch (vec.columnRadix[i - 1]) {
            case 2: {
                vec.columnRadix[i - 1] = 10;
                break;
            }
            case 10: {
                vec.columnRadix[i - 1] = 16;
                break;
            }
            default: {
                vec.columnRadix[i - 1] = 2;
            }
        }
        this.table.modelChanged();
    }

    @Override
    public int getColumnCount() {
        TestVector vec = this.getModel().getVector();
        return vec == null ? 0 : vec.columnName.length + 1;
    }

    @Override
    public String getColumnName(int i) {
        TestVector vec = this.getModel().getVector();
        return i == 0 ? Strings.S.get("statusHeader") : vec.columnName[i - 1];
    }

    @Override
    public int getColumnValueRadix(int i) {
        TestVector vec = this.getModel().getVector();
        return i == 0 ? 0 : vec.columnRadix[i - 1];
    }

    @Override
    public BitWidth getColumnValueWidth(int i) {
        TestVector vec = this.getModel().getVector();
        return i == 0 ? null : vec.columnWidth[i - 1];
    }

    Model getModel() {
        return this.testFrame.getModel();
    }

    @Override
    public int getRowCount() {
        TestVector vec = this.getModel().getVector();
        return vec == null ? 0 : vec.data.size();
    }

    @Override
    public void getRowData(int firstRow, int numRows, ValueTable.Cell[][] rowData) {
        Model model = this.getModel();
        TestException[] results = model.getResults();
        int numPass = model.getPass();
        int numFail = model.getFail();
        TestVector vec = model.getVector();
        int columns = vec.columnName.length;
        String[] msg = new String[columns];
        Value[] altdata = new Value[columns];
        String passMsg = Strings.S.get("passStatus");
        String failMsg = Strings.S.get("failStatus");
        for (int i = firstRow; i < firstRow + numRows; ++i) {
            int row = model.sortedIndex(i);
            Value[] data = vec.data.get(row);
            String rowmsg = null;
            String status = null;
            boolean failed = false;
            if (row < numPass + numFail) {
                TestException err = results[row];
                if (err instanceof FailException) {
                    FailException failEx = (FailException)err;
                    failed = true;
                    for (FailException e : failEx.getAll()) {
                        int col = e.getColumn();
                        msg[col] = Strings.S.get("expectedValueMessage", e.getExpected().toDisplayString(this.getColumnValueRadix(col + 1)));
                        altdata[col] = e.getComputed();
                    }
                } else if (err != null) {
                    failed = true;
                    rowmsg = err.getMessage();
                }
                status = failed ? failMsg : passMsg;
            }
            rowData[i - firstRow][0] = new ValueTable.Cell(status, rowmsg != null ? failColor : null, null, rowmsg);
            for (int col = 0; col < columns; ++col) {
                rowData[i - firstRow][col + 1] = new ValueTable.Cell(altdata[col] != null ? altdata[col] : data[col], msg[col] != null ? failColor : null, null, msg[col]);
                msg[col] = null;
                altdata[col] = null;
            }
        }
    }

    public void localeChanged() {
        this.table.modelChanged();
    }

    public void modelChanged(Model oldModel, Model newModel) {
        if (oldModel != null) {
            oldModel.removeModelListener(this.myListener);
        }
        if (newModel != null) {
            newModel.addModelListener(this.myListener);
        }
        this.table.setModel(newModel == null ? null : this);
    }

    private class MyListener
    implements ModelListener {
        private MyListener() {
        }

        @Override
        public void testingChanged() {
        }

        @Override
        public void testResultsChanged(int numPass, int numFail) {
            TestPanel.this.table.dataChanged();
        }

        @Override
        public void vectorChanged() {
            TestPanel.this.table.modelChanged();
        }
    }
}

