/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.file.Loader;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.util.MacCompatibility;
import com.cburch.logisim.util.PropertyChangeWeakSupport;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;

public final class Projects {
    public static final String PROJECT_LIST_PROPERTY = "projectList";
    private static final WeakHashMap<Window, Point> frameLocations = new WeakHashMap();
    private static final MyListener myListener = new MyListener();
    private static final PropertyChangeWeakSupport propertySupport = new PropertyChangeWeakSupport(Projects.class);
    private static final ArrayList<Project> openProjects = new ArrayList();
    private static Frame mostRecentFrame = null;

    private Projects() {
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(listener);
    }

    public static void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public static Project findProjectFor(File query) {
        for (Project proj : openProjects) {
            File f;
            Loader loader = proj.getLogisimFile().getLoader();
            if (loader == null || !query.equals(f = loader.getMainFile())) continue;
            return proj;
        }
        return null;
    }

    public static Point getCenteredLoc(int width, int height) {
        int x = 0;
        int y = 0;
        Frame topFrame = Projects.getTopFrame();
        if (topFrame != null) {
            x = topFrame.getX() + topFrame.getWidth() / 2;
            x -= width / 2;
            y = topFrame.getY() + topFrame.getHeight() / 2;
            y -= height / 2;
        }
        return new Point(x, y);
    }

    public static Point getLocation(Window win) {
        Point ret = frameLocations.get(win);
        return ret == null ? null : (Point)ret.clone();
    }

    public static List<Project> getOpenProjects() {
        return Collections.unmodifiableList(openProjects);
    }

    public static Frame getTopFrame() {
        Frame ret = mostRecentFrame;
        if (ret == null) {
            Frame backup = null;
            for (Project proj : openProjects) {
                Frame frame = proj.getFrame();
                if (ret == null) {
                    ret = frame;
                }
                if (!ret.isVisible() || (ret.getExtendedState() & 1) == 0) continue;
                backup = ret;
            }
            if (ret == null) {
                ret = backup;
            }
        }
        return ret;
    }

    private static void projectRemoved(Project proj, Frame frame, MyListener listener) {
        frame.removeWindowListener(listener);
        openProjects.remove(proj);
        proj.getSimulator().shutDown();
        propertySupport.firePropertyChange(PROJECT_LIST_PROPERTY, null, null);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    static void windowCreated(Project proj, Frame oldFrame, Frame frame) {
        if (oldFrame != null) {
            Projects.projectRemoved(proj, oldFrame, myListener);
        }
        if (frame == null) {
            return;
        }
        Point lowest = null;
        for (Project p : openProjects) {
            Frame f = p.getFrame();
            if (f == null) continue;
            Point loc = p.getFrame().getLocation();
            if (lowest != null && loc.y <= lowest.y) continue;
            lowest = loc;
        }
        if (lowest != null) {
            Dimension sz = frame.getToolkit().getScreenSize();
            int x = Math.min(lowest.x + 20, sz.width - 200);
            int y = Math.min(lowest.y + 20, sz.height - 200);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            frame.setLocation(x, y);
        }
        if (frame.isVisible() && !openProjects.contains(proj)) {
            openProjects.add(proj);
            propertySupport.firePropertyChange(PROJECT_LIST_PROPERTY, null, null);
        }
        frame.addWindowListener(myListener);
    }

    public static boolean windowNamed(String name) {
        for (Project proj : openProjects) {
            if (!proj.getLogisimFile().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static class MyListener
    extends WindowAdapter {
        private MyListener() {
        }

        @Override
        public void windowActivated(WindowEvent event) {
            mostRecentFrame = (Frame)event.getSource();
        }

        @Override
        public void windowClosed(WindowEvent event) {
            Project proj;
            Frame frame = (Frame)event.getSource();
            if (frame == (proj = frame.getProject()).getFrame()) {
                Projects.projectRemoved(proj, frame, this);
            }
            if (openProjects.isEmpty() && !MacCompatibility.isSwingUsingScreenMenuBar()) {
                ProjectActions.doQuit();
            }
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Frame frame = (Frame)event.getSource();
            if ((frame.getExtendedState() & 1) == 0) {
                mostRecentFrame = frame;
                try {
                    frameLocations.put(frame, frame.getLocationOnScreen());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void windowOpened(WindowEvent event) {
            Project proj;
            Frame frame = (Frame)event.getSource();
            if (frame == (proj = frame.getProject()).getFrame() && !openProjects.contains(proj)) {
                openProjects.add(proj);
                propertySupport.firePropertyChange(Projects.PROJECT_LIST_PROPERTY, null, null);
            }
        }
    }
}

