/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class SocBusTransaction {
    public static final int BLOCK_SKIP = 2;
    public static final int BLOCK_MARKER = 14;
    public static final int BLOCK_HEX = 78;
    public static final int READ_TRANSACTION = 1;
    public static final int WRITE_TRANSACTION = 2;
    public static final int ATOMIC_TRANSACTION = 4;
    public static final int NO_ERROR = 0;
    public static final int NO_RESPONS_ERROR = 1;
    public static final int NO_SLAVES_ERROR = 2;
    public static final int MULTIPLE_SLAVES_ERROR = 3;
    public static final int NONE_ATOMIC_READ_WRITE_ERROR = 4;
    public static final int NO_SOC_BUS_CONNECTED_ERROR = 5;
    public static final int MISALIGNED_ADDRESS_ERROR = 6;
    public static final int ACCESS_TYPE_NOT_SUPPORTED_ERROR = 7;
    public static final int READ_ONLY_ACCESS_ERROR = 8;
    public static final int WRITE_ONLY_ACCESS_ERROR = 9;
    public static final int REGISTER_DOES_NOT_EXIST_ERROR = 10;
    public static final int BYTE_ACCESS = 1;
    public static final int HALF_WORD_ACCESS = 2;
    public static final int WORD_ACCESS = 3;
    private final int address;
    private final int writeData;
    private int readData;
    private final int type;
    private final int access;
    private final Object master;
    private Component slave;
    private int error;
    private boolean hidden;

    public SocBusTransaction(int type, int addr, int value, int access, Object master) {
        this.type = type;
        this.address = addr;
        this.writeData = value;
        this.access = access;
        this.master = master;
        this.slave = null;
        this.readData = 0;
        this.error = 0;
        this.hidden = false;
    }

    public void setAsHiddenTransaction() {
        this.hidden = true;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public int getAccessType() {
        return this.access;
    }

    public String getErrorMessage() {
        return switch (this.error) {
            case 0 -> Strings.S.get("SocTransactionSuccessfull");
            case 1 -> Strings.S.get("SocTransactionNoRespons");
            case 2 -> Strings.S.get("SocTransactionNoSlavesAttached");
            case 3 -> Strings.S.get("SocTransactionMultipleSlaveAnswers");
            case 4 -> Strings.S.get("SocTransactionNoneAtomicRW");
            case 5 -> Strings.S.get("SocTransactionNoBusConnected");
            case 6 -> Strings.S.get("SocTransactionMisalignedAddress");
            case 7 -> {
                switch (this.access) {
                    case 1: {
                        yield Strings.S.get("SocTransactionByteAccesNoSupport");
                    }
                    case 2: {
                        yield Strings.S.get("SocTransactionHalfWordAccesNoSupport");
                    }
                }
                yield Strings.S.get("SocTransactionWordAccesNoSupport");
            }
            case 8 -> Strings.S.get("SocTransactionReadOnlyAccessError");
            case 9 -> Strings.S.get("SocTransactionWriteOnlyAccessError");
            case 10 -> Strings.S.get("SocTransactionRegisterDoesNotExist");
            default -> Strings.S.get("SocTransactionUnknownError");
        };
    }

    public String getShortErrorMessage() {
        return switch (this.error) {
            case 0 -> Strings.S.get("SocTransactionSuccessfullShort");
            case 1 -> Strings.S.get("SocTransactionNoResponsShort");
            case 2 -> Strings.S.get("SocTransactionNoSlavesAttachedShort");
            case 3 -> Strings.S.get("SocTransactionMultipleSlaveAnswersShort");
            case 4 -> Strings.S.get("SocTransactionNoneAtomicRWShort");
            case 5 -> Strings.S.get("SocTransactionNoBusConnectedShort");
            case 6 -> Strings.S.get("SocTransactionMisalignedAddressShort");
            case 7 -> {
                switch (this.access) {
                    case 1: {
                        yield Strings.S.get("SocTransactionByteAccesNoSupportShort");
                    }
                    case 2: {
                        yield Strings.S.get("SocTransactionHalfWordAccesNoSupportShort");
                    }
                }
                yield Strings.S.get("SocTransactionWordAccesNoSupportShort");
            }
            case 8 -> Strings.S.get("SocTransactionReadOnlyAccessErrorShort");
            case 9 -> Strings.S.get("SocTransactionWriteOnlyAccessErrorShort");
            case 10 -> Strings.S.get("SocTransactionRegisterDoesNotExistShort");
            default -> Strings.S.get("SocTransactionUnknownErrorShort");
        };
    }

    public int getType() {
        return this.type;
    }

    public void setError(int value) {
        this.error = value;
    }

    public boolean hasError() {
        return this.error != 0;
    }

    public boolean isReadTransaction() {
        return (this.type & 1) != 0;
    }

    public boolean isWriteTransaction() {
        return (this.type & 2) != 0;
    }

    public boolean isAtomicTransaction() {
        return (this.type & 4) != 0;
    }

    public int getAddress() {
        return this.address;
    }

    public int getReadData() {
        return this.readData;
    }

    public int getWriteData() {
        return this.writeData;
    }

    public void setReadData(int value) {
        this.readData = value;
    }

    private String getTransactionInitiatorName() {
        Object object = this.master;
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        object = this.master;
        if (object instanceof Component) {
            Component comp = (Component)object;
            return SocSupport.getComponentName(comp);
        }
        return "BUG";
    }

    public Object getTransactionInitiator() {
        return this.master;
    }

    private String getTransactionResponderName() {
        return SocSupport.getComponentName(this.slave);
    }

    public Component getTransactionResponder() {
        return this.slave;
    }

    public void setTransactionResponder(Component comp) {
        this.slave = comp;
    }

    private void paintTraceInfo(Graphics2D g2, BoxInfo boxInfo, boolean isRequest, boolean scale) {
        Graphics2D gfx = (Graphics2D)g2.create();
        if (!scale) {
            gfx.setColor(Color.BLACK);
            gfx.drawLine(0, 0, 0, 28);
        }
        if (this.hasError() && !isRequest) {
            gfx.setColor(Color.RED);
            gfx.setFont(StdAttr.DEFAULT_LABEL_FONT);
            Bounds bds = this.getScaled(boxInfo.blockWidth / 2, 14, 0, 0, scale);
            GraphicsUtil.drawCenteredText(gfx, this.getShortErrorMessage(), bds.getX(), bds.getY());
            gfx.dispose();
            return;
        }
        String title = isRequest ? Strings.S.get("SocBusStateMaster") + this.getTransactionInitiatorName() : Strings.S.get("SocBusStateSlave") + this.getTransactionResponderName();
        Bounds bds = this.getScaled(boxInfo.blockWidth / 2, 7, 0, 0, scale);
        GraphicsUtil.drawCenteredText(gfx, title, bds.getX(), bds.getY());
        bds = this.getScaled(boxInfo.skip, 15, boxInfo.mark + boxInfo.hex, 14, scale);
        gfx.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        bds = this.getScaled(boxInfo.skip + boxInfo.mark, 15, 0, 28, scale);
        gfx.drawLine(bds.getX(), bds.getY(), bds.getX(), bds.getHeight());
        bds = this.getScaled(boxInfo.skip + boxInfo.mark / 2, 21, 0, 0, scale);
        GraphicsUtil.drawCenteredText(gfx, "A", bds.getX(), bds.getY());
        String addrStr = String.format("0x%08X", this.getAddress());
        bds = this.getScaled(boxInfo.skip + boxInfo.mark + boxInfo.hex / 2, 21, 0, 0, scale);
        GraphicsUtil.drawCenteredText(gfx, addrStr, bds.getX(), bds.getY());
        bds = this.getScaled(boxInfo.skip + boxInfo.mark + boxInfo.hex, 0, 0, 0, scale);
        gfx.translate(bds.getX(), 0);
        bds = this.getScaled(boxInfo.skip, 15, boxInfo.mark + boxInfo.hex, 14, scale);
        gfx.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        bds = this.getScaled(boxInfo.skip + boxInfo.mark, 15, 0, 28, scale);
        gfx.drawLine(bds.getX(), bds.getY(), bds.getX(), bds.getHeight());
        bds = this.getScaled(boxInfo.skip + boxInfo.mark / 2, 21, 0, 0, scale);
        GraphicsUtil.drawCenteredText(gfx, "D", bds.getX(), bds.getY());
        if (isRequest && this.isWriteTransaction() || !isRequest && this.isReadTransaction()) {
            String format = switch (this.getAccessType()) {
                case 2 -> "0x%04X";
                case 1 -> "0x%02X";
                default -> "0x%08X";
            };
            addrStr = String.format(format, isRequest ? this.getWriteData() : this.getReadData());
        } else {
            addrStr = Strings.S.get("SocBusStateNoDataMax10chars");
        }
        bds = this.getScaled(boxInfo.skip + boxInfo.mark + boxInfo.hex / 2, 21, 0, 0, scale);
        GraphicsUtil.drawCenteredText(gfx, addrStr, bds.getX(), bds.getY());
        if (!isRequest) {
            gfx.dispose();
            return;
        }
        bds = this.getScaled(boxInfo.skip + boxInfo.mark + boxInfo.hex, 0, 0, 0, scale);
        gfx.translate(bds.getX(), 0);
        if (this.isAtomicTransaction()) {
            gfx.setColor(Color.yellow);
            bds = this.getScaled(0, 15, boxInfo.mark, 14, scale);
            gfx.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            gfx.setColor(Color.BLUE);
            bds = this.getScaled(boxInfo.mark / 2, 21, 0, 0, scale);
            GraphicsUtil.drawCenteredText(gfx, "A", bds.getX(), bds.getY());
            gfx.setColor(Color.BLACK);
        }
        bds = this.getScaled(boxInfo.skip + boxInfo.mark, 0, 0, 0, scale);
        gfx.translate(bds.getX(), 0);
        if (this.isWriteTransaction()) {
            bds = this.getScaled(0, 15, boxInfo.mark, 14, scale);
            gfx.setColor(Color.MAGENTA);
            gfx.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            gfx.setColor(Color.BLACK);
            bds = this.getScaled(boxInfo.mark / 2, 21, 0, 0, scale);
            GraphicsUtil.drawCenteredText(gfx, "W", bds.getX(), bds.getY());
        }
        bds = this.getScaled(boxInfo.skip + boxInfo.mark, 0, 0, 0, scale);
        gfx.translate(bds.getX(), 0);
        if (this.isReadTransaction()) {
            bds = this.getScaled(0, 15, boxInfo.mark, 14, scale);
            gfx.setColor(Color.CYAN);
            gfx.fillRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            bds = this.getScaled(boxInfo.mark / 2, 21, 0, 0, scale);
            gfx.setColor(Color.BLACK);
            GraphicsUtil.drawCenteredText(gfx, "R", bds.getX(), bds.getY());
        }
        gfx.dispose();
    }

    public void paint(int x, int y, Graphics2D g2, Long index) {
        BoxInfo realWidth = this.getRealBlockWidth(g2, false);
        Graphics2D gfx = (Graphics2D)g2.create();
        gfx.translate(x, y);
        gfx.setColor(Color.WHITE);
        gfx.fillRect(0, 0, 628, 29);
        gfx.setColor(Color.BLACK);
        gfx.drawRect(0, 0, 628, 29);
        GraphicsUtil.drawCenteredText(gfx, Strings.S.get("SocBusStateTraceIndex"), 79, 7);
        GraphicsUtil.drawCenteredText(gfx, index.toString(), 79, 21);
        gfx.translate(158, 0);
        this.paintTraceInfo(gfx, realWidth, true, false);
        gfx.translate(235, 0);
        this.paintTraceInfo(gfx, realWidth, false, false);
        gfx.dispose();
    }

    private BoxInfo getRealBlockWidth(Graphics2D gfx, boolean scale) {
        BoxInfo boxInfo = new BoxInfo();
        if (scale) {
            boxInfo.skip = AppPreferences.getScaled(2);
            double prefferedMark = AppPreferences.getScaled(14);
            double prefferedHex = AppPreferences.getScaled(78);
            FontMetrics fntMetrics = gfx.getFontMetrics();
            double realHex = fntMetrics.getStringBounds("0x00000000", gfx).getWidth();
            double corFactor = realHex <= prefferedHex ? 1.0 : realHex / prefferedHex;
            boxInfo.mark = AppPreferences.getDownScaled((int)Math.round(corFactor * prefferedMark));
            boxInfo.hex = AppPreferences.getDownScaled((int)Math.round(corFactor * prefferedHex));
            boxInfo.blockWidth = 6 * boxInfo.skip + 5 * boxInfo.mark + 2 * boxInfo.hex;
        } else {
            boxInfo.skip = 2;
            boxInfo.mark = 14;
            boxInfo.hex = 78;
            boxInfo.blockWidth = 238;
        }
        return boxInfo;
    }

    private Bounds getScaled(int x, int y, int width, int height, boolean scale) {
        return scale ? Bounds.create(AppPreferences.getScaled(x), AppPreferences.getScaled(y), AppPreferences.getScaled(width), AppPreferences.getScaled(height)) : Bounds.create(x, y, width, height);
    }

    public int paint(Graphics2D g2, Long index, int width) {
        BoxInfo realWidth = this.getRealBlockWidth(g2, true);
        int usedWidth = Math.max(realWidth.blockWidth, width);
        Bounds bds = this.getScaled(usedWidth / 2, 7, usedWidth, 15, true);
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(0, 0, bds.getWidth(), bds.getHeight() - 1);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, bds.getWidth(), bds.getHeight() - 1);
        GraphicsUtil.drawCenteredText(g2, Strings.S.get("SocBusStateTraceIndex") + " " + index.toString(), bds.getX(), bds.getY());
        g2.translate(0, bds.getHeight());
        bds = this.getScaled(0, 0, usedWidth, 30, true);
        g2.drawLine(0, -1, bds.getWidth(), -1);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 1, bds.getWidth() - 2, bds.getHeight() - 1);
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 1, bds.getWidth() - 2, bds.getHeight() - 1);
        this.paintTraceInfo(g2, realWidth, true, true);
        bds = this.getScaled(0, 0, usedWidth, 30, true);
        g2.translate(0, bds.getHeight());
        g2.setColor(Color.YELLOW);
        g2.fillRect(0, 0, bds.getWidth(), bds.getHeight());
        g2.setColor(Color.BLACK);
        g2.drawLine(0, 0, bds.getWidth(), 0);
        this.paintTraceInfo(g2, realWidth, false, true);
        return usedWidth;
    }

    private static class BoxInfo {
        private int skip;
        private int mark;
        private int hex;
        private int blockWidth;

        private BoxInfo() {
        }
    }
}

