/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.gui;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.tools.CircuitStateHolder;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.StringGetter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class ListeningFrame
extends JFrame
implements BaseWindowListenerContract,
LocaleListener,
CircuitListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private final StringGetter title;
    private final String upName;
    private final CircuitStateHolder.HierarchyInfo hierInfo;

    public ListeningFrame(String upName, StringGetter t, CircuitStateHolder.HierarchyInfo h) {
        LocaleManager.addLocaleListener(this);
        this.title = t;
        this.hierInfo = h;
        this.upName = upName + " ";
        if (h != null) {
            h.registerCircuitListener(this);
            h.registerComponentListener(this);
        }
        this.updateTitle();
        this.setDefaultCloseOperation(2);
    }

    public ListeningFrame(StringGetter t) {
        LocaleManager.addLocaleListener(this);
        this.title = t;
        this.upName = "";
        this.hierInfo = null;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.hierInfo == null) {
            this.setTitle(this.upName + this.title.toString());
        } else {
            this.setTitle(this.upName + String.valueOf(this.title) + " " + this.hierInfo.getName());
        }
    }

    public String getParentTitle() {
        return this.upName + String.valueOf(this.title) + " " + this.hierInfo.getName();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void localeChanged() {
        this.updateTitle();
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        if (event.getAction() == 0) {
            this.updateTitle();
        }
    }

    @Override
    public void labelChanged(ComponentEvent e) {
        this.updateTitle();
    }
}

