/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.rv32im.RV32imState;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32im_M_ExtensionInstructions
implements AssemblerExecutionInterface {
    private static final int OP = 51;
    private static final int INSTR_MUL = 0;
    private static final int INSTR_MULH = 1;
    private static final int INSTR_MULHSU = 2;
    private static final int INSTR_MULHU = 3;
    private static final int INSTR_DIV = 4;
    private static final int INSTR_DIVU = 5;
    private static final int INSTR_REM = 6;
    private static final int INSTR_REMU = 7;
    private static final String[] AsmOpcodes = new String[]{"MUL", "MULH", "MULHSU", "MULHU", "DIV", "DIVU", "REM", "REMU"};
    private int instruction;
    private boolean valid;
    private int operation;
    private int destination;
    private int source1;
    private int source2;

    @Override
    public ArrayList<String> getInstructions() {
        return new ArrayList<String>(Arrays.asList(AsmOpcodes));
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        RV32imState.ProcessorState cpuState = (RV32imState.ProcessorState)state;
        int val1 = cpuState.getRegisterValue(this.source1);
        int val2 = cpuState.getRegisterValue(this.source2);
        BigInteger mask = BigInteger.valueOf(1L).shiftLeft(32).subtract(BigInteger.valueOf(1L));
        int result = 0;
        switch (this.operation) {
            case 0: 
            case 1: {
                BigInteger opp1 = BigInteger.valueOf(val1);
                BigInteger opp2 = BigInteger.valueOf(val2);
                BigInteger res = opp1.multiply(opp2);
                result = this.operation == 0 ? res.and(mask).intValue() : res.shiftRight(32).and(mask).intValue();
                break;
            }
            case 2: {
                BigInteger opp1 = BigInteger.valueOf(val1);
                BigInteger opp2 = BigInteger.valueOf(ElfHeader.getLongValue(val2));
                BigInteger res = opp1.multiply(opp2);
                result = res.shiftRight(32).and(mask).intValue();
                break;
            }
            case 3: {
                BigInteger opp1 = BigInteger.valueOf(ElfHeader.getLongValue(val1));
                BigInteger opp2 = BigInteger.valueOf(ElfHeader.getLongValue(val2));
                BigInteger res = opp1.multiply(opp2);
                result = res.shiftRight(32).and(mask).intValue();
                break;
            }
            case 4: 
            case 6: {
                BigInteger opp1 = BigInteger.valueOf(val1);
                BigInteger opp2 = BigInteger.valueOf(val2);
                BigInteger res = this.operation == 6 ? opp1.remainder(opp2) : opp1.divide(opp2);
                result = res.and(mask).intValue();
                break;
            }
            case 5: 
            case 7: {
                BigInteger opp1 = BigInteger.valueOf(ElfHeader.getLongValue(val1));
                BigInteger opp2 = BigInteger.valueOf(ElfHeader.getLongValue(val2));
                BigInteger res = this.operation == 7 ? opp1.remainder(opp2) : opp1.divide(opp2);
                result = res.and(mask).intValue();
            }
        }
        cpuState.writeRegister(this.destination, result);
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(RV32imState.registerABINames[this.destination]).append(",").append(RV32imState.registerABINames[this.source1]).append(",").append(RV32imState.registerABINames[this.source2]);
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean decodeBin() {
        if (RV32imSupport.getOpcode(this.instruction) == 51) {
            if (RV32imSupport.getFunct7(this.instruction) != 1) {
                return false;
            }
            this.operation = RV32imSupport.getFunct3(this.instruction);
            this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
            this.source1 = RV32imSupport.getSourceRegister1Index(this.instruction);
            this.source2 = RV32imSupport.getSourceRegister2Index(this.instruction);
            return true;
        }
        return false;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        this.valid = true;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        if (instr.getNrOfParameters() != 3) {
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
            this.valid = false;
            return true;
        }
        AssemblerToken[] param1 = instr.getParameter(0);
        AssemblerToken[] param2 = instr.getParameter(1);
        AssemblerToken[] param3 = instr.getParameter(2);
        boolean errors = false;
        if (param1.length != 1 || param1[0].getType() != 5) {
            instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
            errors = true;
        }
        if (param2.length != 1 || param2[0].getType() != 5) {
            instr.setError(param2[0], Strings.S.getter("AssemblerExpectedRegister"));
            errors = true;
        }
        if (param3.length != 1 || param3[0].getType() != 5) {
            instr.setError(param3[0], Strings.S.getter("AssemblerExpectedRegister"));
            errors = true;
        }
        this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
        if (this.destination < 0 || this.destination > 31) {
            instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
            errors = true;
        }
        this.source1 = RV32imState.getRegisterIndex(param2[0].getValue());
        if (this.source1 < 0 || this.source1 > 31) {
            instr.setError(param2[0], Strings.S.getter("AssemblerUnknownRegister"));
            errors = true;
        }
        this.source2 = RV32imState.getRegisterIndex(param3[0].getValue());
        if (this.source2 < 0 || this.source2 > 31) {
            instr.setError(param3[0], Strings.S.getter("AssemblerUnknownRegister"));
            errors = true;
        }
        boolean bl = this.valid = !errors;
        if (this.valid) {
            this.instruction = RV32imSupport.getRTypeInstruction(51, this.destination, operation, this.source1, this.source2, 1);
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }
}

