/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.hdl.HdlModelListener;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.util.Arrays;

public abstract class HdlContent
implements HdlModel,
Cloneable {
    protected EventSourceWeakSupport<HdlModelListener> listeners = null;

    protected static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    protected HdlContent() {
    }

    @Override
    public void addHdlModelListener(HdlModelListener l) {
        if (this.listeners == null) {
            this.listeners = new EventSourceWeakSupport();
        }
        this.listeners.add(l);
    }

    public HdlContent clone() throws CloneNotSupportedException {
        HdlContent ret = (HdlContent)super.clone();
        ret.listeners = null;
        return ret;
    }

    protected void fireContentSet() {
        if (this.listeners == null) {
            return;
        }
        boolean found = false;
        for (HdlModelListener l : this.listeners) {
            found = true;
            l.contentSet(this);
        }
        if (!found) {
            this.listeners = null;
        }
    }

    @Override
    public void removeHdlModelListener(HdlModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }
}

