/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.hdl.HdlContent;
import com.cburch.logisim.std.hdl.HdlContentEditor;
import com.cburch.logisim.vhdl.Strings;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public class HdlContentAttribute<C extends HdlContent>
extends Attribute<C> {
    private static final WeakHashMap<HdlContent, HdlContentEditor> windowRegistry = new WeakHashMap();
    private final Supplier<C> contentFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HdlContentEditor getContentEditor(Window source, HdlContent value, Project proj) {
        WeakHashMap<HdlContent, HdlContentEditor> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            HdlContentEditor ret = windowRegistry.get(value);
            if (ret == null) {
                if (source instanceof com.cburch.logisim.gui.main.Frame) {
                    com.cburch.logisim.gui.main.Frame frame = (com.cburch.logisim.gui.main.Frame)source;
                    ret = new HdlContentEditor((Frame)frame, proj, (HdlModel)value);
                } else {
                    ret = new HdlContentEditor((Dialog)source, proj, (HdlModel)value);
                }
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    public HdlContentAttribute(Supplier<C> creator) {
        super("content", Strings.S.getter("vhdlContentAttr"));
        this.contentFactory = creator;
    }

    @Override
    public Component getCellEditor(Window source, C value) {
        Project project;
        if (source instanceof com.cburch.logisim.gui.main.Frame) {
            com.cburch.logisim.gui.main.Frame frame = (com.cburch.logisim.gui.main.Frame)source;
            project = frame.getProject();
        } else {
            project = null;
        }
        Project proj = project;
        return HdlContentAttribute.getContentEditor(source, value, proj);
    }

    @Override
    public C parse(String value) {
        HdlContent content = (HdlContent)this.contentFactory.get();
        if (!content.compare(value)) {
            content.setContent(value);
        }
        return (C)content;
    }

    @Override
    public String toDisplayString(HdlContent value) {
        return Strings.S.get("vhdlContentValue");
    }

    @Override
    public String toStandardString(HdlContent value) {
        return value.getContent();
    }
}

