/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.util.LineBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ReptarLocalBusHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public ReptarLocalBusHdlGeneratorFactory() {
        this.myPorts.add("inout", "Addr_Data_LB_io", 16, 0).add("input", "SP6_LB_WAIT3_i", 1, 4).add("input", "IRQ_i", 1, 9).add("output", "SP6_LB_nCS3_o", 1, 0).add("output", "SP6_LB_nADV_ALE_o", 1, 1).add("output", "SP6_LB_RE_nOE_o", 1, 2).add("output", "SP6_LB_nWE_o", 1, 3).add("output", "Addr_LB_o", 9, 8);
    }

    @Override
    public List<String> getArchitecture(Netlist nets, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getBuffer();
        if (Hdl.isVhdl()) {
            contents.pair("compName", componentName).add(FileWriter.getGenerateRemark(componentName, nets.projName())).add("\nARCHITECTURE PlatformIndependent OF {{compName}} IS\n\nBEGIN\n\nFPGA_out(0) <= NOT SP6_LB_WAIT3_i;\nFPGA_out(1) <= NOT IRQ_i;\nSP6_LB_nCS3_o       <= FPGA_in(0);\nSP6_LB_nADV_ALE_o   <= FPGA_in(1);\nSP6_LB_RE_nOE_o     <= FPGA_in(2);\nSP6_LB_nWE_o        <= FPGA_in(3);\nAddr_LB_o           <= FPGA_in(11 DOWNTO 4);\n\nIOBUF_Addresses_Datas : for i in 0 to Addr_Data_LB_io'length-1 generate\n  IOBUF_Addresse_Data : IOBUF\n  generic map (\n    DRIVE => 12,\n    IOSTANDARD => \"LVCMOS18\"\n    SLEW => \"FAST\"\n  )\n  port map (\n    O => Addr_Data_LB_o(i), -- Buffer output\n    IO => Addr_Data_LB_io(i), -- Buffer inout port (connect directly to top-level port)\n    I => Addr_Data_LB_i(i), -- Buffer input\n    T => Addr_Data_LB_tris_i -- 3-state enable input, high=input, low=output\n  );\nend generate;\n\nEND PlatformIndependent;\n");
        }
        return contents.get();
    }

    @Override
    public LineBuffer getComponentInstantiation(Netlist theNetlist, AttributeSet attrs, String componentName) {
        return LineBuffer.getBuffer().add("COMPONENT LocalBus\n   PORT ( SP6_LB_WAIT3_i     : IN  std_logic;\n          IRQ_i              : IN  std_logic;\n          Addr_Data_LB_io    : INOUT  std_logic_vector( 15 DOWNTO 0 );\n          Addr_LB_o          : OUT std_logic_vector( 8 DOWNTO 0 );\n          SP6_LB_RE_nOE_o    : OUT std_logic;\n          SP6_LB_nADV_ALE_o  : OUT std_logic;\n          SP6_LB_nCS3_o      : OUT std_logic;\n          SP6_LB_nWE_o       : OUT std_logic;\n          FPGA_in            : IN std_logic_vector(12 downto 0);\n          FPGA_out           : OUT std_logic_vector(1 downto 0);\n         Addr_Data_LB_i      : IN std_logic_vector(15 downto 0);\n         Addr_Data_LB_o      : OUT std_logic_vector(15 downto 0);\n         Addr_Data_LB_tris_i : IN std_logic);\nEND COMPONENT;\n");
    }

    @Override
    public List<String> getEntity(Netlist nets, AttributeSet attrs, String componentName) {
        return LineBuffer.getBuffer().pair("compName", componentName).add(FileWriter.getGenerateRemark(componentName, nets.projName())).add(Hdl.getExtendedLibrary()).add("Library UNISIM;\nuse UNISIM.vcomponents.all;\n\nENTITY {{compName}} IS\n   PORT ( Addr_Data_LB_io     : INOUT std_logic_vector(15 downto 0);\n          SP6_LB_nCS3_o       : OUT std_logic;\n          SP6_LB_nADV_ALE_o   : OUT std_logic;\n          SP6_LB_RE_nOE_o     : OUT std_logic;\n          SP6_LB_nWE_o        : OUT std_logic;\n          SP6_LB_WAIT3_i      : IN std_logic;\n          IRQ_i               : IN std_logic;\n          FPGA_in             : IN std_logic_vector(12 downto 0);\n          FPGA_out            : OUT std_logic_vector(1 downto 0);\n          Addr_LB_o           : OUT std_logic_vector(8 downto 0);\n          Addr_Data_LB_o      : OUT std_logic_vector(15 downto 0);\n          Addr_Data_LB_i      : IN std_logic_vector(15 downto 0);\n          Addr_Data_LB_tris_i : IN std_logic);\nEND {{compName}};\n").get();
    }

    @Override
    public Map<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (!(mapInfo instanceof netlistComponent)) {
            return map;
        }
        netlistComponent componentInfo = (netlistComponent)mapInfo;
        map.putAll(super.getPortMap(nets, mapInfo));
        map.put("Addr_Data_LB_io", String.format("%s(%d DOWNTO %d)", "logisimInOutBubbles", componentInfo.getLocalBubbleInOutEndId(), componentInfo.getLocalBubbleInOutStartId()));
        map.put("FPGA_in", String.format("%s(%d DOWNTO %d)", "logisimInputBubbles", componentInfo.getLocalBubbleInputEndId(), componentInfo.getLocalBubbleInputStartId()));
        map.put("FPGA_out", String.format("%s(%d DOWNTO %d)", "logisimOutputBubbles", componentInfo.getLocalBubbleOutputEndId(), componentInfo.getLocalBubbleOutputStartId()));
        map.putAll(Hdl.getNetMap("Addr_Data_LB_o", true, componentInfo, 5, nets));
        map.putAll(Hdl.getNetMap("Addr_Data_LB_i", true, componentInfo, 6, nets));
        map.putAll(Hdl.getNetMap("Addr_Data_LB_tris_i", true, componentInfo, 7, nets));
        return map;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }
}

