/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.start.TtyInterface;
import com.cburch.logisim.instance.InstanceData;
import java.util.Arrays;

class TtyState
implements InstanceData,
Cloneable {
    private Value lastClock = Value.UNKNOWN;
    private String[] rowData;
    private int colCount;
    private final StringBuilder lastRow;
    private int row;
    private boolean sendStdout;

    public TtyState(int rows, int cols) {
        this.rowData = new String[rows - 1];
        this.colCount = cols;
        this.lastRow = new StringBuilder(cols);
        this.sendStdout = false;
        this.clear();
    }

    public void add(char c) {
        if (this.sendStdout) {
            TtyInterface.sendFromTty(c);
        }
        int lastLength = this.lastRow.length();
        switch (c) {
            case '\f': {
                this.row = 0;
                this.lastRow.delete(0, lastLength);
                Arrays.fill(this.rowData, "");
                break;
            }
            case '\b': {
                if (lastLength <= 0) break;
                this.lastRow.delete(lastLength - 1, lastLength);
                break;
            }
            case '\n': 
            case '\r': {
                this.commit();
                break;
            }
            default: {
                if (Character.isISOControl(c)) break;
                if (lastLength == this.colCount) {
                    this.commit();
                }
                this.lastRow.append(c);
            }
        }
    }

    public void clear() {
        Arrays.fill(this.rowData, "");
        this.lastRow.delete(0, this.lastRow.length());
        this.row = 0;
    }

    @Override
    public TtyState clone() {
        try {
            TtyState ret = (TtyState)super.clone();
            ret.rowData = (String[])this.rowData.clone();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void commit() {
        if (this.row >= this.rowData.length) {
            System.arraycopy(this.rowData, 1, this.rowData, 0, this.rowData.length - 1);
            this.rowData[this.row - 1] = this.lastRow.toString();
        } else {
            this.rowData[this.row] = this.lastRow.toString();
            ++this.row;
        }
        this.lastRow.delete(0, this.lastRow.length());
    }

    public int getCursorColumn() {
        return this.lastRow.length();
    }

    public int getCursorRow() {
        return this.row;
    }

    public String getRowString(int index) {
        if (index < this.row) {
            return this.rowData[index];
        }
        if (index == this.row) {
            return this.lastRow.toString();
        }
        return "";
    }

    public Value setLastClock(Value newClock) {
        Value ret = this.lastClock;
        this.lastClock = newClock;
        return ret;
    }

    public void setSendStdout(boolean value) {
        this.sendStdout = value;
    }

    public int getNrRows() {
        return this.rowData.length + 1;
    }

    public int getNrCols() {
        return this.colCount;
    }

    public void updateSize(int rows, int cols) {
        int oldCols;
        int oldRows = this.rowData.length + 1;
        if (rows != oldRows) {
            Object[] newData = new String[rows - 1];
            if (rows > oldRows || this.row < rows - 1) {
                System.arraycopy(this.rowData, 0, newData, 0, this.row);
                Arrays.fill(newData, this.row, rows - 1, "");
            } else {
                System.arraycopy(this.rowData, this.row - rows + 1, newData, 0, rows - 1);
                this.row = rows - 1;
            }
            this.rowData = newData;
        }
        if (cols != (oldCols = this.colCount)) {
            this.colCount = cols;
            if (cols < oldCols) {
                for (int i = 0; i < rows - 1; ++i) {
                    String s = this.rowData[i];
                    if (s.length() <= cols) continue;
                    this.rowData[i] = s.substring(0, cols);
                }
                if (this.lastRow.length() > cols) {
                    this.lastRow.delete(cols, this.lastRow.length());
                }
            }
        }
    }
}

