/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class AbstractGateHdlGenerator
extends AbstractHdlGeneratorFactory {
    private final boolean isInverter;

    public AbstractGateHdlGenerator() {
        this(false);
    }

    public AbstractGateHdlGenerator(boolean isInverter) {
        this.isInverter = isInverter;
        int nrOfGates = isInverter ? 6 : 4;
        for (int gate = 0; gate < nrOfGates; ++gate) {
            int outindex;
            int inindex1 = gate < 2 ? gate * 3 : gate * 3 + 1;
            int inindex2 = inindex1 + 1;
            int n = outindex = gate < 2 ? gate * 3 + 2 : gate * 3;
            if (isInverter) {
                inindex1 = gate < 3 ? gate * 2 : gate * 2 + 1;
                outindex = gate < 3 ? gate * 2 + 1 : gate * 2;
            }
            this.myPorts.add("input", String.format("gateA%d", gate), 1, inindex1).add("output", String.format("gateO%d", gate), 1, outindex);
            if (isInverter) continue;
            this.myPorts.add("input", String.format("gateB%d", gate), 1, inindex2);
        }
    }

    public LineBuffer getLogicFunction(int index) {
        return LineBuffer.getHdlBuffer();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        int nrOfGates = this.isInverter ? 6 : 4;
        for (int i = 0; i < nrOfGates; ++i) {
            contents.addRemarkBlock("Here gate %d is described", i).add(this.getLogicFunction(i));
        }
        return contents;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

