/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import java.util.ArrayList;

public class Ttl74157
extends AbstractTtlGate {
    public static final String _ID = "74157";
    public static final byte SELECT = 1;
    public static final byte L1_A = 2;
    public static final byte L1_B = 3;
    public static final byte L1_Y = 4;
    public static final byte L2_A = 5;
    public static final byte L2_B = 6;
    public static final byte L2_Y = 7;
    public static final byte GND = 8;
    public static final byte L3_Y = 9;
    public static final byte L3_B = 10;
    public static final byte L3_A = 11;
    public static final byte L4_Y = 12;
    public static final byte L4_B = 13;
    public static final byte L4_A = 14;
    public static final byte STROBE = 15;
    public static final byte VCC = 16;
    public static final int DELAY = 1;
    protected final boolean invertOutput;
    protected static final String[] pinNames = new String[]{"SELECT", "1A", "1B", "1Y", "2A", "2B", "2Y", "3Y", "3B", "3A", "4Y", "4B", "4A", "nSTROBE (active LOW)"};
    private static final byte pinCount = 16;
    private static final byte[] outPins = new byte[]{4, 7, 9, 12};

    public Ttl74157() {
        super(_ID, (byte)16, outPins, pinNames, null);
        this.invertOutput = false;
    }

    public Ttl74157(String icName, boolean invertOutput) {
        super(icName, (byte)16, outPins, pinNames, null);
        this.invertOutput = invertOutput;
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int maxLabelLength = 4;
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.portNames) {
            String[] tmp = name.split("\\s+");
            names.add(tmp[0].length() <= 4 ? tmp[0] : tmp[0].substring(0, 4));
        }
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, names.toArray(new String[0]));
    }

    protected byte mapPort(byte dsIdx) {
        return (byte)(dsIdx <= 8 ? dsIdx - 1 : dsIdx - 2);
    }

    protected Value computeState(InstanceState state, byte inA, byte inB) {
        boolean Y;
        boolean B;
        boolean strobe = state.getPortValue(this.mapPort((byte)15)) == Value.TRUE;
        boolean select = state.getPortValue(this.mapPort((byte)1)) == Value.TRUE;
        boolean A = state.getPortValue(this.mapPort(inA)) == Value.TRUE;
        boolean bl = B = state.getPortValue(this.mapPort(inB)) == Value.TRUE;
        boolean bl2 = strobe ? false : (Y = select ? B : A);
        if (this.invertOutput) {
            Y = !Y;
        }
        return Y ? Value.TRUE : Value.FALSE;
    }

    @Override
    public void propagateTtl(InstanceState state) {
        state.setPort(this.mapPort((byte)4), this.computeState(state, (byte)2, (byte)3), 1);
        state.setPort(this.mapPort((byte)7), this.computeState(state, (byte)5, (byte)6), 1);
        state.setPort(this.mapPort((byte)9), this.computeState(state, (byte)11, (byte)10), 1);
        state.setPort(this.mapPort((byte)12), this.computeState(state, (byte)14, (byte)13), 1);
    }
}

