/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LibraryTools {
    private LibraryTools() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static void showErrors(String libName, Map<String, String> messages) {
        OptionPane.showMessageDialog(null, LibraryTools.message(libName, messages), Strings.S.get("LibLoadErrors") + " " + libName + " !", 0);
    }

    private static String message(String libName, Map<String, String> messages) {
        String message = "";
        int item = 0;
        for (String myerror : messages.keySet()) {
            message = message.concat(++item + ") " + messages.get(myerror) + " \"" + myerror + "\".\n");
        }
        return message;
    }

    public static void buildToolList(Library lib, Set<String> tools) {
        for (Tool tool : lib.getTools()) {
            tools.add(tool.getName().toUpperCase());
        }
        for (Library library : lib.getLibraries()) {
            LibraryTools.buildToolList(library, tools);
        }
    }

    public static boolean buildToolList(Library lib, Map<String, AddTool> tools) {
        boolean ret = true;
        if (!"Base".equals(lib.getName())) {
            for (Tool tool : lib.getTools()) {
                if (tools.containsKey(tool.getName().toUpperCase())) {
                    ret = false;
                    continue;
                }
                tools.put(tool.getName().toUpperCase(), (AddTool)tool);
            }
        }
        for (Library library : lib.getLibraries()) {
            ret &= LibraryTools.buildToolList(library, tools);
        }
        return ret;
    }

    public static Circuit getCircuitFromLibs(Library lib, String upperCaseName) {
        if (lib instanceof LogisimFile) {
            LogisimFile llib = (LogisimFile)lib;
            for (Circuit circ : llib.getCircuits()) {
                if (!circ.getName().equalsIgnoreCase(upperCaseName)) continue;
                return circ;
            }
        }
        Circuit ret = null;
        for (Library libs : lib.getLibraries()) {
            if (libs instanceof LoadedLibrary) {
                LoadedLibrary lib1 = (LoadedLibrary)libs;
                ret = LibraryTools.getCircuitFromLibs(lib1.getBase(), upperCaseName);
            } else {
                ret = LibraryTools.getCircuitFromLibs(libs, upperCaseName);
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static List<String> libraryCanBeMerged(Set<String> sourceTools, Set<String> newTools) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String This : newTools) {
            if (!sourceTools.contains(This)) continue;
            ret.add(This);
        }
        return ret;
    }

    public static Map<String, String> getToolLocation(Library lib, String location, List<String> upercasedNames) {
        String MyLocation;
        Iterator<? extends Tool> toolIter = lib.getTools().iterator();
        HashMap<String, String> ret = new HashMap<String, String>();
        String string = MyLocation = location.isEmpty() ? lib.getName() : location + "->" + lib.getName();
        while (toolIter.hasNext()) {
            Tool tool = toolIter.next();
            if (!upercasedNames.contains(tool.getName().toUpperCase())) continue;
            ret.put(tool.getName(), MyLocation);
        }
        for (Library sublib : lib.getLibraries()) {
            ret.putAll(LibraryTools.getToolLocation(sublib, MyLocation, upercasedNames));
        }
        return ret;
    }

    public static boolean isLibraryConform(Library lib, Set<String> names, Set<String> tools, Map<String, String> error) {
        Iterator<? extends Tool> toolIter = lib.getTools().iterator();
        boolean hasErrors = false;
        while (toolIter.hasNext()) {
            Tool tool = toolIter.next();
            if (tools.contains(tool.getName().toUpperCase())) {
                hasErrors = true;
                if (!error.containsKey(tool.getName())) {
                    error.put(tool.getName(), Strings.S.get("LibraryHasDuplicatedTools"));
                }
            }
            tools.add(tool.getName().toUpperCase());
        }
        for (Library sublib : lib.getLibraries()) {
            if (names.contains(sublib.getName().toUpperCase())) {
                hasErrors = true;
                if (!error.containsKey(sublib.getName())) {
                    error.put(sublib.getName(), Strings.S.get("LibraryHasDuplicatedSublibraries"));
                }
            }
            names.add(sublib.getName().toUpperCase());
            hasErrors |= !LibraryTools.isLibraryConform(sublib, names, tools, error);
        }
        return !hasErrors;
    }

    public static void buildLibraryList(Library lib, Map<String, Library> names) {
        names.put(lib.getName().toUpperCase(), lib);
        for (Library sublib : lib.getLibraries()) {
            LibraryTools.buildLibraryList(sublib, names);
        }
    }

    public static void removePresentLibraries(Library lib, Map<String, Library> knownLibs, boolean addToSet) {
        HashSet<String> toBeRemoved = new HashSet<String>();
        for (Library sublib : lib.getLibraries()) {
            if (knownLibs.containsKey(sublib.getName().toUpperCase())) {
                toBeRemoved.add(sublib.getName());
                continue;
            }
            if (!addToSet) continue;
            knownLibs.put(sublib.getName().toUpperCase(), sublib);
        }
        for (String remove : toBeRemoved) {
            lib.removeLibrary(remove);
        }
        for (Library sublib : lib.getLibraries()) {
            LibraryTools.removePresentLibraries(sublib, knownLibs, addToSet);
        }
    }
}

