/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class JDialogOk
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contents = new JPanel(new BorderLayout());
    protected final JButton ok = new JButton(Strings.S.get("dlogOkButton"));
    protected final JButton cancel = new JButton(Strings.S.get("dlogCancelButton"));
    protected Window parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();

    public JDialogOk(String title) {
        this(title, true);
    }

    public JDialogOk(String title, boolean withCancel) {
        super(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), title, Dialog.ModalityType.APPLICATION_MODAL);
        this.configure(withCancel);
    }

    public void cancelClicked() {
    }

    private void configure(boolean withCancel) {
        MyListener listener = new MyListener();
        this.addWindowListener(listener);
        this.ok.addActionListener(listener);
        this.cancel.addActionListener(listener);
        Box buttons = Box.createHorizontalBox();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.ok);
        if (withCancel) {
            buttons.add(Box.createHorizontalStrut(10));
            buttons.add(this.cancel);
        }
        buttons.add(Box.createHorizontalGlue());
        Container pane = super.getContentPane();
        pane.add((Component)this.contents, "Center");
        pane.add((Component)buttons, "South");
        this.getRootPane().registerKeyboardAction(e -> {
            this.setVisible(false);
            this.cancelClicked();
            this.dispose();
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                JDialogOk.this.ok.requestFocus();
                e.getWindow().removeWindowListener(this);
            }
        });
    }

    @Override
    public Container getContentPane() {
        return this.contents;
    }

    @Override
    public void pack() {
        super.pack();
        while (this.parent != null && !this.parent.isShowing()) {
            this.parent = this.parent.getOwner();
        }
        this.setLocationRelativeTo(this.parent);
        this.parent = null;
    }

    public abstract void okClicked();

    private class MyListener
    extends WindowAdapter
    implements ActionListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == JDialogOk.this.ok) {
                JDialogOk.this.okClicked();
                JDialogOk.this.dispose();
            } else if (src == JDialogOk.this.cancel) {
                JDialogOk.this.cancelClicked();
                JDialogOk.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JDialogOk.this.removeWindowListener(this);
            JDialogOk.this.cancelClicked();
            JDialogOk.this.dispose();
        }
    }
}

