/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.util.StringGetter;
import java.awt.Font;
import java.awt.FontMetrics;

public final class StringUtil {
    private StringUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static StringGetter constantGetter(final String value) {
        return new StringGetter(){

            @Override
            public String toString() {
                return value;
            }
        };
    }

    public static String resizeString(String value, FontMetrics metrics, int maxWidth) {
        int width = metrics.stringWidth(value);
        if (width < maxWidth) {
            return value;
        }
        if (value.length() < 4) {
            return value;
        }
        return StringUtil.resizeString(new StringBuilder(value.substring(0, value.length() - 3) + ".."), metrics, maxWidth);
    }

    private static String resizeString(StringBuilder value, FontMetrics metrics, int maxWidth) {
        int width = metrics.stringWidth(value.toString());
        if (width < maxWidth) {
            return value.toString();
        }
        if (value.length() < 4) {
            return value.toString();
        }
        return StringUtil.resizeString(value.delete(value.length() - 3, value.length() - 2), metrics, maxWidth);
    }

    public static String toHexString(int bits, long value) {
        if (bits < 64) {
            value &= (1L << bits) - 1L;
        }
        int len = (bits + 3) / 4;
        String ret = String.format("%0" + len + "x", value);
        return ret.length() > len ? ret.substring(ret.length() - len) : ret;
    }

    public static Bounds estimateBounds(String text, Font font) {
        return StringUtil.estimateBounds(text, font, -1, -1);
    }

    public static Bounds estimateBounds(String text, Font font, int hAlign, int vAlign) {
        if (text == null || text.length() == 0) {
            text = "X";
        }
        int n = 0;
        int c = 0;
        int lines = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                n = Math.max(c, n);
                c = 0;
                ++lines;
                continue;
            }
            if (text.charAt(i) == '\t') {
                c += 4;
                continue;
            }
            ++c;
        }
        if (text.charAt(text.length() - 1) != '\n') {
            n = Math.max(c, n);
            ++lines;
        }
        int size = font.getSize();
        int h = size * lines;
        int w = size * n * 2 / 3;
        int x = hAlign == -1 ? 0 : (hAlign == 1 ? -w : -w / 2);
        int y = vAlign == -1 ? 0 : (vAlign == 0 ? -h / 2 : -h);
        return Bounds.create(x, y, w, h);
    }

    public static boolean isNullOrEmpty(CharSequence str) {
        return str == null ? true : str.isEmpty();
    }

    public static boolean isNotEmpty(CharSequence seq) {
        return seq != null ? !seq.isEmpty() : false;
    }

    public static boolean startsWith(String seq, String prefix) {
        return seq != null ? seq.startsWith(prefix) : false;
    }
}

