#ifndef _COLUMN_H_
#define _COLUMN_H_


#define REALOC_SIZE 255
#define ASC  0
#define DESC 1

enum enum_type {NULLVAL = 1 , UINT, INT, USHORT, SHORT, ULONG,
                LONG, UCHAR, CHAR, FLOAT, DOUBLE, STRING, OBJECT };
typedef enum enum_type Enum_Type;


union column_type{
  unsigned int             uint_value;
  signed   int             int_value;
  unsigned short           ushort_value;
  signed   short           short_value;
  unsigned long long int   ulong_int;
  signed long long int     long_int;
  unsigned char            uchar_value;
  signed char              char_value;
  float                    float_value;
  double                   double_value;
  char*                    string_value;
  void*                    object_value;
};

typedef union column_type Column_Type ;


struct column {
  char* column_name;
  //taille logique
  unsigned int size;
  //taille physique 
  unsigned int max_size;
  Enum_Type column_type;
  // tableau de pointeur de valeurs 
  Column_Type** data;
  // tableau d'index 
  unsigned long long  *index;
  unsigned int index_size;
  // index valid
  // 0  : no index
  // -1 : invalid index
  // 1  : valid index 
  char valid_index;
  char sort_dir;
};

typedef struct column Column;

Column* create_column(Enum_Type type);
int  check_value(Enum_Type type, void * value);
int  inser_value(Column* col, void * value);
int  check_space_column(Column* col);

void print_col(Column* col);
void print_col_index(Column* col);
void info_column(Column* col);
void print_value(Column* col, unsigned long long int i, char* str, int size);
void print_col_by_index(Column* col);

void create_index(Column* col);
void erase_index(Column* col);
void sort(Column* col, int sort_dir);
int  check_index(Column* col);
int  update_index(Column* col);


Column* applay_function_column(Column* col_1, Column*  col_2, Enum_Type dftype, void *(*fct)(void *,void*));

Column_Type* applay_function_column_linue(Column* col, void *(*fct)(void *,void*));

#endif
