#include <stdlib.h>
#include <string.h>
#include "sort.h"

int cmp(Enum_Type type, void *a, void *b){
  if (a == NULL && b == NULL) return  0;
  if (a != NULL && b == NULL) return  1;
  if (a == NULL && b != NULL) return -1;

  switch(type){
  case UINT:
  case INT:
    if((int)*((int*)(a))  ==  (int)*((int*)(b))) return 0;
    return ((int)*((int*)(a))  >  (int)*((int*)(b))) ? 1 : -1;
    break;
  case USHORT:
  case SHORT:
    if((short)*((short*)(a))  ==  (short)*((short*)(b))) return 0;
    return ((short)*((short*)(a))  >  (short)*((short*)(b))) ? 1 : -1;
    break;
  case ULONG:
  case LONG:
    if((long)*((long*)(a))  ==  (long)*((long*)(b))) return 0;
    return ((long)*((long*)(a))  >  (long)*((long*)(b))) ? 1 : -1;
    break;
  case UCHAR:
  case CHAR:
    if((char)*((char*)(a))  ==  (char)*((char*)(b))) return 0;
    return ((char)*((char*)(a))  >  (char)*((char*)(b))) ? 1 : -1;
    break;
  case FLOAT:
    if((float)*((float*)(a))  ==  (float)*((float*)(b))) return 0;
    return ((float)*((float*)(a))  >  (float)*((float*)(b))) ? 1 : -1;
    break;
  case DOUBLE:
    if((double)*((double*)(a))  ==  (double)*((double*)(b))) return 0;
    return ((double)*((double*)(a))  >  (double)*((double*)(b))) ? 1 : -1;
    break;
  case STRING:
    return strcmp((char*)(a) , (char*)(b));
    break;
  case OBJECT:
    return 0;
    break;
  };

}


void insertion_sort(Column* col){
	int i;
  void ** data = (void**)col->data;

	for(i=1; i < col->size ; i++){
    int x = col->index[i];
		void *val = (void*)col->data[x];
		int j;
		for(j=i ; j>0 &&  cmp(col->column_type, col->data[col->index[j-1]], val)== 1 ; j--){
			col->index[j] = col->index[j-1];
    }
		col->index[j] = x;
	}
}

void quick_sort(Column* col, int(*pivot)(unsigned long long*,int,int)){
	quick_sort_rec(col,0,col->size-1,pivot);
}


void quick_sort_rec(Column* col, int f, int l, int(*pivot)(unsigned long long*,int,int)){
	if(f<l){
		int p = pivot(col->index,f,l);
		p = partitionate(col,f,l,p);
		quick_sort_rec(col,f,p-1,pivot);
		quick_sort_rec(col,p+1,l,pivot);
	}
}



void swap(long long unsigned int * a, long long unsigned int *b){
  int tmp = *a;
  *a=*b;
  *b=tmp;
}


int partitionate(Column* col, int f, int l, int pivot){
	swap(col->index + f, col->index + pivot);
	pivot=f;
	while(f<l){
    while(f< col->size && cmp(col->column_type, col->data[col->index[f]], col->data[col->index[pivot]]) <= 0 )f++;
    while( l> pivot    && cmp(col->column_type, col->data[col->index[l]], col->data[col->index[pivot]]) >= 0 )l--;
		if(f<l){
			swap(col->index + f, col->index + l);
		}
	}
	swap(col->index + l, col->index + pivot);
	return l;
}


int pivot_first(unsigned long long  *t,int f,int l){
	return f;
}


int pivot_middle(unsigned long long  *t,int f,int l){
	return (l-f)/2+f;
}


int pivot_random(unsigned long long  *t,int f,int l){
	return rand()%(l-f+1)+f;
}

